unit UProgTL;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, HTMLTreeList;

type
  TForm1 = class(TForm)
    HTMLTreeList1: THTMLTreeList;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.Button1Click(Sender: TObject);
begin
  with htmltreelist1 do
  begin
    with Columns.Add do
    begin
      Header := 'Column 1';
      Color := clInfoBk;
      Width := 150;
    end;
    with Columns.Add do
    begin
      Header := 'Column 2';
      Width := 150;
    end;
    with Columns.Add do
    begin
      Header := 'Column 3';
      Font.Style := [fsItalic];
    end;
  end;
  button1.Enabled := false;
  button2.Enabled := true;
end;

procedure TForm1.Button2Click(Sender: TObject);
var
  tn1,tn2,tn3,tn: TTreeNode;
begin
  tn1 := HTMLTreeList1.Items.Add(nil,'Node 1');
  HTMLTreeList1.SetNodeColumn(tn1, 1, 'Node 1, <b>column 1</b>');
  tn2 := HTMLTreeList1.Items.Add(nil,'Node 2');
  HTMLTreeList1.SetNodeColumn(tn2, 1, 'Node 2, <i>column 1</i>');
  tn3 := HTMLTreeList1.Items.Add(nil,'Node 3');
  HTMLTreeList1.SetNodeColumn(tn3, 1, 'Node 3, <u>column 1</u>');
  tn := HTMLTreeList1.Items.AddChild(tn1,'Subnode 1');
  HTMLTreeList1.SetNodeColumn(tn, 1, 'Subnode A, column 1');
  tn := HTMLTreeList1.Items.AddChild(tn1,'Subnode 2');
  HTMLTreeList1.SetNodeColumn(tn, 1, 'Subnode B, column 1');
  button2.Enabled := false;
  button3.Enabled := true;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  if Assigned(HTMLTreeList1.Selected) then
    HTMLTreeList1.SetNodeColumn(HTMLTreeList1.Selected, 2, '<font color="clred">selected</font>')
  else
    ShowMessage('No node selected');
end;

end.
